# IN

Joe 想要从员工表

```sql
create table employee(
    id int primary key auto_increment,
    dept_id int,
    name varchar(256),
    post varchar(16)
)
```

中查询出研发部（dept为'rd')和人力资源部(dept为'hr')的员工列表，这个查询应该怎么写？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select id, dept, name, post 
from employee
where dept in ('dev', 'hr');
```

## 选项

### A

```sql
select id, dept, name, post 
from employee
where dept in (select 'dev', 'hr');
```

### B

```sql
select id, dept, name, post 
from employee
where dept in 
      (select * 
       from 'dev', 'hr');
```

### C

```sql
select id, dept, name, post 
from employee
where dept in ('dev' and 'hr');
```

### D

```sql
select id, dept, name, post 
from employee
where dept in ('dev' or 'hr');
```
